# IntegSec CSP Tester Browser Extension

A simple browser extension to test Content Security Policy headers on any website.

## Installation

### Chrome/Edge

1. Download the extension ZIP file from the IntegSec CSP Builder website
2. Extract the ZIP file to a folder
3. Open Chrome/Edge and navigate to:
   - Chrome: `chrome://extensions/`
   - Edge: `edge://extensions/`
4. Enable "Developer mode" (toggle in top-right)
5. Click "Load unpacked"
6. Select the extracted extension folder
7. The extension icon will appear in your toolbar

## Usage

The extension has two modes:

### 👁️ View Mode (Default)
- Automatically detects and displays the CSP of any website you visit
- Explains each directive in plain English
- Shows the raw CSP header
- No configuration needed - just browse and view!

### 🧪 Test Mode
1. Click the extension icon and switch to "Test Mode"
2. Paste your CSP policy into the text area (or build one at cspbuilder.integsec.com)
3. Toggle "Enable CSP Injection" to ON
4. Navigate to any website
5. Open the browser console (F12) to see CSP violation reports

## Features

- **View Mode**: Automatically decode and explain CSP headers on any website
- **Test Mode**: Inject your own CSP to test security configurations
- Easy CSP injection on any website
- Toggle on/off functionality
- Paste from clipboard support
- Plain English explanations of all CSP directives
- Links to cspbuilder.integsec.com for building CSPs
- Syncs across devices (if signed into Chrome/Edge)
- Clean, user-friendly interface matching IntegSec branding

## Building Icons

### Option 1: Use the Icon Generator (Recommended)
1. Open `create-icons.html` in your browser
2. Click each "Download" button to save the icons
3. Save them as `icon16.png`, `icon48.png`, and `icon128.png` in the `icons/` folder

### Option 2: Create Icons Manually
You'll need to create icon files:
- `icons/icon16.png` (16x16 pixels)
- `icons/icon48.png` (48x48 pixels)
- `icons/icon128.png` (128x128 pixels)

Use the IntegSec logo or create a simple shield/lock icon in the neon yellow (#FFD700) color scheme.

An SVG template is provided in `icons/icon.svg` that you can convert to PNG at different sizes.

## Packaging the Extension

### Windows (PowerShell)
```powershell
cd extension
.\package-extension.ps1
```

### Mac/Linux (Bash)
```bash
cd extension
chmod +x package-extension.sh
./package-extension.sh
```

This will create `extension.zip` in the parent directory, ready for download from your website.

## Notes

- The extension uses Chrome's declarativeNetRequest API to inject CSP headers
- CSP violations will appear in the browser console
- The extension only affects HTTP response headers, not meta tags
- Disable the extension when not testing to avoid interfering with normal browsing

