// Content script to read CSP from meta tags and send to background
(function() {
    // Look for CSP meta tag
    const cspMeta = document.querySelector('meta[http-equiv="Content-Security-Policy"]');
    
    if (cspMeta && cspMeta.content) {
        // Send CSP to background script
        chrome.runtime.sendMessage({
            action: 'setPageCSP',
            csp: cspMeta.content,
            tabId: null // Will be set by background
        });
    }
})();

